/*
 * Decompiled with CFR 0.152.
 */
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;

public class SimpleServer
extends SimpleNetworking
implements HttpHandler {
    private HttpServer server;
    private SimpleServerListener requestListener;
    private int port;

    public SimpleServer(SimpleServerListener listener, int port) {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Port out of range: " + port);
        }
        this.requestListener = listener;
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    private static String getUriString(HttpExchange exchange) {
        URI uri = exchange.getRequestURI();
        String uriStr = uri.toString();
        uriStr = uriStr.substring(1);
        return uriStr;
    }

    public boolean isRunning() {
        return this.server != null;
    }

    public boolean portIsAvailable() {
        return SimpleServer.portIsAvailable(this.port);
    }

    /*
     * Loose catch block
     */
    public static boolean portIsAvailable(int port) {
        Socket ignored;
        block12: {
            ignored = null;
            ignored = new Socket("localhost", port);
            if (ignored == null) break block12;
            try {
                ignored.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
        catch (IOException ioe) {
            if (ignored != null) {
                try {
                    ignored.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return true;
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        if (!SimpleServer.portIsAvailable(this.port)) {
            System.out.println("Port " + this.port + " is not available, likely because \nit's already being used by another Java program running. \n" + "Close all your server windows and try again.");
            throw new IllegalArgumentException("Port " + this.port + " is not available. " + "Close all server windows and try again.");
        }
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            this.server.createContext("/", this);
            this.server.setExecutor(null);
            this.server.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        this.server.stop(0);
        this.server = null;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "port=" + this.port + ", running=" + this.isRunning() + (this.requestListener == null ? "" : ", listener=\"" + this.requestListener + "\"") + "}";
    }

    @Override
    public void handle(HttpExchange t) throws IOException {
        try {
            String uriStr = SimpleServer.getUriString(t);
            Request request = Request.fromUrl(uriStr);
            String responseStr = null;
            if (this.requestListener != null) {
                responseStr = this.requestListener.requestMade(request);
            }
            if (responseStr == null) {
                throw new NullPointerException("Server request returned null response.");
            }
            t.sendResponseHeaders(200, responseStr.length());
            OutputStream os = t.getResponseBody();
            os.write(responseStr.getBytes());
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

